/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.field;

import java.math.BigInteger;

public enum LEIValidator {
    LEI_VALIDATOR;

    protected static final BigInteger MODULOS_97;
    protected static final int LEI_LENGTH = 20;

    public static boolean validate(String lei) {
        if (lei == null) {
            return false;
        }
        if (lei.length() != 20) {
            return false;
        }
        if (!Character.isDigit(lei.charAt(18)) || !Character.isDigit(lei.charAt(19))) {
            return false;
        }
        for (int i = 0; i < 18; ++i) {
            if (Character.isLetterOrDigit(lei.charAt(i))) continue;
            return false;
        }
        return LEIValidator.numerify(lei).mod(MODULOS_97).intValue() == 1;
    }

    private static BigInteger numerify(String lei) {
        StringBuilder numerifiedLEI = new StringBuilder(lei.length() * 2);
        for (int i = 0; i < lei.length(); ++i) {
            char curChar = lei.charAt(i);
            if (Character.isDigit(curChar)) {
                numerifiedLEI.append(curChar);
                continue;
            }
            if (Character.isUpperCase(curChar)) {
                numerifiedLEI.append(curChar - 65 + 10);
                continue;
            }
            if (!Character.isLowerCase(curChar)) continue;
            numerifiedLEI.append(curChar - 97 + 10);
        }
        return new BigInteger(numerifiedLEI.toString());
    }

    static {
        MODULOS_97 = BigInteger.valueOf(97L);
    }
}

