/*
 * Decompiled with CFR 0.152.
 */
package pt.at.efapi.service;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jdom.Document;
import org.jdom.Element;
import pt.at.efapi.enums.EfapiErrorEnum;
import pt.at.efapi.exception.ConfigFileException;
import pt.at.efapi.exception.RemoteServiceException;
import pt.at.efapi.service.RemoteService;
import pt.at.efapi.service.ServiceConfiguration;
import pt.at.efapi.service.UserDTO;
import pt.at.efapi.util.EfapiLog;
import pt.at.efapi.util.LogUtils;
import pt.opensoft.io.FileResourceFactory;
import pt.opensoft.io.FileUtil;
import pt.opensoft.io.ResourceLoader;
import pt.opensoft.util.ByteUtil;

public class UploadService
extends RemoteService {
    private static final String OPERATION_UPLOAD = "efapiUploadFile";
    private static final String PARAMETER_FILECONTENT = "filecontent";
    private static final String UPLOAD_ENDPOINT = "/enviarFicheiro";

    public UploadService() {
        ResourceLoader.addResourceFactory(new FileResourceFactory());
    }

    public void run(UserDTO userDTO, String filename, String directory, String filetype) throws RemoteServiceException, ConfigFileException {
        if (userDTO == null || filename == null || filetype == null || directory == null) {
            throw new IllegalArgumentException("UploadService: Illegal Arguments");
        }
        long start = System.currentTimeMillis();
        try {
            File testDirectory = new File(directory);
            if (!testDirectory.isDirectory()) {
                EfapiLog.writeLog("UploadServiceException: the directory " + directory + " is invalid");
                throw new RemoteServiceException(EfapiErrorEnum.INVALID_DIRECTORY);
            }
            File file = new File(directory, filename);
            this.validate(file);
            this.init(new URL(ServiceConfiguration.getServerUrl() + UPLOAD_ENDPOINT));
            this.addUserParameters(userDTO);
            this.addOperationParameters(OPERATION_UPLOAD);
            this.addParameter("filename", file.getName());
            this.addParameter(PARAMETER_FILECONTENT, UploadService.zip(ByteUtil.toString(FileUtil.readBinaryFile(file))));
            LogUtils.getUploadFileTags(filename, file.length());
            this.addFiletypeParameter(filetype);
            EfapiLog.infoWriteLog("Attempting to send file '" + file.getName() + "'");
        }
        catch (MalformedURLException e) {
            EfapiLog.writeLog("Upload Service: error setting the URL");
            throw new RemoteServiceException(EfapiErrorEnum.COMMUNICATION_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            EfapiLog.writeLog("Upload Service: unable to zip file");
            throw new RemoteServiceException(EfapiErrorEnum.UPLOAD_FAILED, (Throwable)e);
        }
        Document result = this.send();
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - start;
        this.processResponseUpload(result);
        LogUtils.getErrorCodeAndResult(Integer.parseInt("0"), "OK");
        String logToPrint = LogUtils.prepareLogStructure();
        EfapiLog.logToConsole(logToPrint, elapsedTime);
        EfapiLog.infoWriteLog(logToPrint, elapsedTime);
        EfapiLog.infoWriteLog("Sent file successfully.");
    }

    private void validate(File file) throws RemoteServiceException {
        if (file == null) {
            EfapiLog.writeLog("Upload Service(validateFile): File does not exist.");
            throw new RemoteServiceException(EfapiErrorEnum.FILE_NOT_EXISTS);
        }
        if (!(file.exists() && file.isFile() && file.canRead())) {
            EfapiLog.writeLog("Upload Service(validateFile): error validating file " + file.getName());
            throw new RemoteServiceException(EfapiErrorEnum.FILE_NOT_EXISTS);
        }
        if (file.length() > 0x200000L) {
            EfapiLog.writeLog("Upload Service(validateFile): file " + file.getName() + " as an invalid size.");
            throw new RemoteServiceException(EfapiErrorEnum.INVALID_FILE_SIZE);
        }
    }

    private void processResponseUpload(Document document) throws RemoteServiceException {
        if (document == null || !document.hasRootElement()) {
            EfapiLog.writeLog("Upload Service(processResponseUpload): [ERROR] Answer is empty.");
            throw new RemoteServiceException(EfapiErrorEnum.UPLOAD_FAILED);
        }
        Element element = document.getRootElement();
        if (!element.getAttributeValue("error").equals("0")) {
            Integer codeError = Integer.valueOf(element.getAttributeValue("error"));
            EfapiLog.writeLog("Upload Service(processResponseUpload): [ERROR] Tag error has value " + codeError);
            throw new RemoteServiceException(EfapiErrorEnum.getError(codeError));
        }
        if (element.getAttributeValue("operation") == null || !element.getAttributeValue("operation").equals(OPERATION_UPLOAD)) {
            EfapiLog.writeLog("Upload Service(processResponseUpload): [ERROR] Answer was invalid.");
            throw new RemoteServiceException(EfapiErrorEnum.UPLOAD_FAILED);
        }
    }
}

