/*
 * Decompiled with CFR 0.152.
 */
package pt.at.efapi.service;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import pt.at.efapi.exception.ConfigFileException;

public final class ServiceConfiguration {
    public static final long MAX_UPLOAD_FILE_SIZE = 0x200000L;
    private static final long DEFAULT_TIMEOUT = 100000L;
    public static final int MAX_NUM_OF_CHARS = 246;
    private static final String configFile = "config.properties";
    private static String proxyHost;
    private static int proxyPort;
    private static String proxyUser;
    private static String proxyPass;
    private static String serverUrl;
    private static long timeout;

    private ServiceConfiguration() {
    }

    public static String getServerUrl() throws ConfigFileException {
        if (serverUrl == null) {
            ServiceConfiguration.readServerUrl();
        }
        return serverUrl;
    }

    public static void setServerUrl(String serverUrl) {
        ServiceConfiguration.serverUrl = serverUrl;
    }

    public static long getTimeout() throws ConfigFileException {
        if (timeout == 0L) {
            ServiceConfiguration.readTimeout();
        }
        return timeout;
    }

    public static void setTimeout(long timeout) {
        ServiceConfiguration.timeout = timeout;
    }

    public static String getProxyHost() throws ConfigFileException {
        if (proxyHost == null) {
            ServiceConfiguration.readProxyHost();
        }
        return proxyHost;
    }

    public static void setProxyHost(String proxyHost) {
        ServiceConfiguration.proxyHost = proxyHost;
    }

    public static int getProxyPort() throws ConfigFileException {
        if (proxyPort == 0) {
            ServiceConfiguration.readProxyPort();
        }
        return proxyPort;
    }

    public static void setProxyPort(int proxyPort) {
        ServiceConfiguration.proxyPort = proxyPort;
    }

    public static String getProxyUser() throws ConfigFileException {
        if (proxyUser == null) {
            ServiceConfiguration.readProxyUser();
        }
        return proxyUser;
    }

    public static void setProxyUser(String proxyUser) {
        ServiceConfiguration.proxyUser = proxyUser;
    }

    public static String getProxyPass() throws ConfigFileException {
        if (proxyPass == null) {
            ServiceConfiguration.readProxyPass();
        }
        return proxyPass;
    }

    public static void setProxyPass(String proxyPass) {
        ServiceConfiguration.proxyPass = proxyPass;
    }

    public static boolean usingProxy() throws ConfigFileException {
        return ServiceConfiguration.getProxyHost() != null && !ServiceConfiguration.getProxyHost().equals("") && ServiceConfiguration.getProxyPort() != 0;
    }

    public static void readServerUrl() throws ConfigFileException {
        serverUrl = ServiceConfiguration.getValueFromConfigFile("server.url");
        if (serverUrl == null) {
            throw new ConfigFileException("Erro ao ler do ficheiro config.properties o valor server.url");
        }
    }

    public static void readTimeout() throws ConfigFileException {
        String communicationTimeout = ServiceConfiguration.getValueFromConfigFile("communication.timeout");
        timeout = communicationTimeout != null ? Long.valueOf(communicationTimeout) : 100000L;
    }

    public static void readProxyHost() throws ConfigFileException {
        proxyHost = ServiceConfiguration.getValueFromConfigFile("proxy.host");
    }

    public static void readProxyPort() throws ConfigFileException {
        try {
            proxyPort = Integer.parseInt(ServiceConfiguration.getValueFromConfigFile("proxy.port"));
        }
        catch (NumberFormatException e) {
            proxyPort = 0;
        }
    }

    public static void readProxyUser() throws ConfigFileException {
        proxyUser = ServiceConfiguration.getValueFromConfigFile("proxy.user");
    }

    public static void readProxyPass() throws ConfigFileException {
        proxyPass = ServiceConfiguration.getValueFromConfigFile("proxy.pass");
    }

    public static String getEfapiConfigFileName() {
        return configFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getValueFromConfigFile(String key) throws ConfigFileException {
        try (FileInputStream inputStreamConfigFile = new FileInputStream(configFile);){
            Properties properties = new Properties();
            properties.load(inputStreamConfigFile);
            String string = properties.getProperty(key);
            return string;
        }
        catch (IOException e) {
            throw new ConfigFileException("Erro ao ler do ficheiro config.properties o valor " + key, e);
        }
    }
}

