/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import pt.opensoft.http.HttpRequest;
import pt.opensoft.util.MultipleResourceBundle;
import pt.opensoft.util.MultipleResourceBundleMap;
import pt.opensoft.util.ResourceBundleControl;
import pt.opensoft.util.StringUtil;
import pt.opensoft.webmvc.action.BeanAction;
import pt.opensoft.webmvc.bean.AbstractResponseBean;
import pt.opensoft.webmvc.bean.InvalidResponseBean;
import pt.opensoft.webmvc.bean.ResponseBean;

public final class I18nUtil {
    private static final Set<Locale> AVAILABLE_LOCALES;

    private I18nUtil() {
    }

    public static Locale getRequestLocale(HttpRequest request) {
        Locale locale = I18nUtil.localeFromString(request.getString("locale"));
        if (locale != null) {
            return locale;
        }
        locale = I18nUtil.localeFromString(request.getSession().getString("locale"));
        if (locale != null) {
            return locale;
        }
        Enumeration locales = request.getLocales();
        while (locales.hasMoreElements()) {
            locale = (Locale)locales.nextElement();
            if (locale == null) continue;
            return locale;
        }
        return Locale.getDefault();
    }

    public static Locale getRequestLocale(HttpRequest request, boolean setCookie) {
        Locale result = I18nUtil.getRequestLocale(request);
        if (setCookie) {
            request.getSession().setValue("locale", (Object)result.toString());
        }
        return result;
    }

    private static Locale localeFromString(String localeString) {
        if (StringUtil.isEmpty(localeString)) {
            return null;
        }
        String[] components = localeString.split("_");
        Locale result = null;
        if (components.length == 0) {
            return Locale.getDefault();
        }
        for (int i = Math.min(2, components.length - 1); i >= 0; --i) {
            result = new Locale(components[0], components.length > 1 ? components[1] : "", components.length > 2 ? components[2] : "");
            if (AVAILABLE_LOCALES.contains(result)) {
                return result;
            }
            components[i] = "";
        }
        return Locale.getDefault();
    }

    private static void translateMessageLists(List<List<String>> messageLists, MultipleResourceBundle mrb) {
        for (List<String> list : messageLists) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, mrb.getString(list.get(i)));
            }
        }
    }

    public static MultipleResourceBundle initOrGetBundle(HttpServletRequest request, boolean setCookie, String[] resourceBundleBaseNames, String encoding) {
        Locale requestLocale = I18nUtil.getRequestLocale(new HttpRequest(request), setCookie);
        return I18nUtil.initOrGetBundle(requestLocale, resourceBundleBaseNames, encoding);
    }

    public static MultipleResourceBundle initOrGetBundle(Locale locale, String[] resourceBundleBaseNames, String encoding) {
        MultipleResourceBundle result;
        if (MultipleResourceBundleMap.getMultipleResourceBundle(locale) == null) {
            LinkedList<ResourceBundle> listResourceBundles = new LinkedList<ResourceBundle>();
            for (String baseName : resourceBundleBaseNames) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, locale, new ResourceBundleControl(encoding));
                listResourceBundles.addLast(resourceBundle);
            }
            result = new MultipleResourceBundle(listResourceBundles, locale);
            MultipleResourceBundleMap.addMultipleBundle(result);
        } else {
            result = MultipleResourceBundleMap.getMultipleResourceBundle(locale);
        }
        return result;
    }

    public static void translateResponseBeans(boolean invalid, MultipleResourceBundle mrb, BeanAction<?, ? extends ResponseBean, ? extends InvalidResponseBean> actionInstance) {
        if (actionInstance == null) {
            return;
        }
        ResponseBean responseBean = actionInstance.getResponseBean();
        AbstractResponseBean.Messages responseMessages = responseBean.getMessages();
        I18nUtil.translateMessageLists(Arrays.asList(responseMessages.getError(), responseMessages.getInfo(), responseMessages.getSuccess(), responseMessages.getWarning()), mrb);
        if (!invalid) {
            return;
        }
        InvalidResponseBean irBean = actionInstance.getInvalidResponseBean();
        if (irBean.errors != null) {
            for (Map.Entry entry : irBean.errors.entrySet()) {
                entry.setValue(mrb.getString((String)entry.getValue()));
            }
        }
        AbstractResponseBean.Messages irMessages = irBean.getMessages();
        I18nUtil.translateMessageLists(Arrays.asList(irMessages.getError(), irMessages.getInfo(), irMessages.getInfo(), irMessages.getWarning()), mrb);
    }

    static {
        Locale[] availableLocales = Locale.getAvailableLocales();
        AVAILABLE_LOCALES = new HashSet<Locale>(availableLocales.length);
        for (Locale locale : availableLocales) {
            AVAILABLE_LOCALES.add(locale);
        }
    }
}

