/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.text;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.anakia.OutputWrapper;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.context.Context;
import pt.opensoft.io.FileUtil;
import pt.opensoft.msg.Session;
import pt.opensoft.text.CachingVelocityEngine;
import pt.opensoft.text.EscapeReferencesHandler;
import pt.opensoft.text.VelocityLogger;
import pt.opensoft.util.VelocityUtil;

public class VelocityRenderer {
    private static VelocityEngine _engine;
    private static VelocityLogger _velocityLogger;
    private static String _globalLibrary;
    private static int _parserPoolSize;
    private static final VelocityUtil _util;
    private static final OutputWrapper _ow;
    private Template _templateFile;
    private String _templateString;
    protected VelocityContext _context;
    private static boolean _escapeRequestReferences;
    private static boolean developmentMode;
    private static String encoding;

    public VelocityRenderer(String template) throws Exception {
        this(template, true);
    }

    public VelocityRenderer(String input, boolean isTemplateFile) throws Exception {
        if (_engine == null) {
            throw new RuntimeException("Engine not initialized. Call initVelocityEngine first!");
        }
        if (isTemplateFile) {
            String loaderPath;
            if (!_engine.templateExists(input) && (loaderPath = (String)_engine.getProperty("file.resource.loader.path")) != null && !loaderPath.equals(".")) {
                input = loaderPath + "/" + input;
            }
            this._templateFile = _engine.getTemplate(input);
        } else {
            this._templateString = input;
        }
        this.reset();
    }

    public void addToContext(String key, Object value) {
        if (value != null) {
            this._context.put(key, value);
        }
    }

    public void removeFromContext(String key) {
        this._context.remove((Object)key);
    }

    public void saveToSession(Session session) {
        session.setValue("velocityContext", (Object)this._context);
    }

    public void loadFromSession(Session session) {
        VelocityContext velocityContext = (VelocityContext)session.getValue("velocityContext");
        if (velocityContext != null) {
            this._context = velocityContext;
        }
    }

    public void clearSession(Session session) {
        session.remove("velocityContext");
    }

    public String render() throws Exception {
        StringWriter sWriter = new StringWriter();
        this.renderToWriter(sWriter);
        return sWriter.getBuffer().toString();
    }

    public void renderToWriter(Writer writer) throws Exception {
        if (this._templateFile != null) {
            this._templateFile.merge((Context)this._context, writer);
        } else if (this._templateString != null) {
            _engine.evaluate((Context)this._context, writer, "VELOCITY", this._templateString);
        }
    }

    public void reset() {
        this._context = null;
        this._context = this.createVelocityContext();
        this._context.put("util", (Object)_util);
        this._context.put("xmlout", (Object)_ow);
        this._context.put("Q", (Object)"\"");
        if (_escapeRequestReferences) {
            EventCartridge ec = new EventCartridge();
            ec.addEventHandler((EventHandler)new EscapeReferencesHandler());
            ec.attachToContext((Context)this._context);
        }
    }

    protected VelocityContext createVelocityContext() {
        return new VelocityContext();
    }

    public static void setDebug(boolean debug) {
        _velocityLogger.setDebug(debug);
    }

    public static void setDevelopmentMode(boolean developmentMode) {
        if (_engine != null) {
            throw new RuntimeException("Engine has already been initialized. Call this method before initVelocityEngine()");
        }
        VelocityRenderer.developmentMode = developmentMode;
    }

    public static void setEncoding(String encoding) {
        if (_engine != null) {
            throw new RuntimeException("Engine has already been initialized. Call this method before initVelocityEngine()");
        }
        VelocityRenderer.encoding = encoding;
    }

    public static void setEscapeRequestReferences(boolean escapeRequestReferences) {
        _escapeRequestReferences = escapeRequestReferences;
    }

    public static void setGlobalLibrary(String globalLibrary) {
        if (_engine != null) {
            throw new RuntimeException("Este m\u00e9todo deve ser invocado ANTES do initVelocityEngine!");
        }
        _globalLibrary = globalLibrary;
    }

    public static void setHasLogger(boolean hasLogger) {
        if (!hasLogger) {
            _velocityLogger = null;
        }
    }

    public static void setParserPoolSize(int parserPoolSize) {
        _parserPoolSize = parserPoolSize;
    }

    public static synchronized void initVelocityEngine(File loaderPath, String resourceLoaders) throws Exception {
        if (_engine != null) {
            throw new RuntimeException("Engine has already been initialized!");
        }
        _engine = new CachingVelocityEngine();
        _engine.setProperty("resource.loader", (Object)resourceLoaders);
        _engine.setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        if (loaderPath != null) {
            _engine.setProperty("file.resource.loader.path", (Object)FileUtil.getNormalizedPath(loaderPath.getPath()));
        }
        _engine.setProperty("classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        _engine.setProperty("war.resource.loader.class", (Object)"pt.opensoft.text.WarVelocityResourceLoader");
        if (developmentMode) {
            _engine.setProperty("file.resource.loader.cache", (Object)"false");
        } else {
            _engine.setProperty("file.resource.loader.cache", (Object)"true");
            _engine.setProperty("file.resource.loader.modificationCheckInterval", (Object)"0");
        }
        _engine.setProperty("runtime.log.invalid.references", (Object)"true");
        _engine.setProperty("velocimacro.library", (Object)_globalLibrary);
        _engine.setProperty("velocimacro.permissions.allow.inline.local.scope", (Object)"true");
        _engine.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        if (_parserPoolSize != -1) {
            _engine.setProperty("parser.pool.size", (Object)String.valueOf(_parserPoolSize));
        }
        if (encoding == null) {
            _ow.setEncoding("ISO-8859-1");
        } else {
            _engine.setProperty("input.encoding", (Object)encoding);
            _engine.setProperty("output.encoding", (Object)encoding);
            _ow.setEncoding(encoding);
        }
        _engine.init();
        if (_velocityLogger != null) {
            _engine.setProperty("runtime.log.logsystem", (Object)_velocityLogger);
        }
    }

    public static synchronized void resetVelocityEngine() {
        _engine = null;
    }

    static {
        _velocityLogger = new VelocityLogger();
        _globalLibrary = "";
        _parserPoolSize = -1;
        _util = new VelocityUtil();
        _ow = new OutputWrapper();
        _escapeRequestReferences = true;
        developmentMode = false;
    }
}

