/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.math;

import java.util.ArrayList;
import java.util.List;

public class Prime {
    private Prime() {
    }

    public static boolean isPrime(long number) {
        if (number < 0L) {
            throw new IllegalArgumentException("illegal negative number: " + number);
        }
        if (number == 0L) {
            return false;
        }
        if (number == 1L) {
            return true;
        }
        if (number == 2L) {
            return true;
        }
        if (number % 2L == 0L) {
            return false;
        }
        if (number == 3L) {
            return true;
        }
        long max = (long)Math.ceil(Math.sqrt(number));
        for (long i = 3L; i <= max; i += 2L) {
            if (number % i != 0L) continue;
            return false;
        }
        return true;
    }

    public static List<Long> factors(long number) {
        ArrayList<Long> factors = new ArrayList<Long>();
        long max = (long)Math.ceil(Math.sqrt(number));
        for (long i = 2L; number > 3L && i <= max; i += 2L) {
            while (number % i == 0L) {
                factors.add(i);
                number /= i;
            }
            if (i != 2L) continue;
            --i;
        }
        if (number > 1L) {
            factors.add(number);
        }
        if (number == 1L && factors.size() == 0) {
            factors.add(number);
        }
        if (number == 0L) {
            factors.add(number);
        }
        return factors;
    }
}

