/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import pt.opensoft.util.DateTime;

public class VariableSizeReader
extends BufferedReader {
    protected char[] _buffer = new char[this.BUFFER_LEN];
    protected StringBuffer _sb = new StringBuffer();
    protected int BUFFER_LEN = 256;

    public VariableSizeReader(String data) {
        this(new StringReader(data));
    }

    public VariableSizeReader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public VariableSizeReader(Reader reader) {
        super(reader);
    }

    public String readString(int len) throws IOException {
        if (len == 0) {
            return "";
        }
        this._sb.setLength(0);
        if (len <= this.BUFFER_LEN) {
            int read = 0;
            do {
                if ((read = this.read(this._buffer, 0, len -= read)) == -1) {
                    throw new IOException("Incomplete message. Expecting more data...");
                }
                this._sb.append(new String(this._buffer, 0, read));
            } while (read < len);
            return this._sb.toString();
        }
        StringBuffer newSb = new StringBuffer("");
        while (len > 0) {
            if (len > this.BUFFER_LEN) {
                newSb.append(this.readString(this.BUFFER_LEN));
                len -= this.BUFFER_LEN;
                continue;
            }
            newSb.append(this.readString(len));
            len = 0;
        }
        return newSb.toString();
    }

    public int readHex(int len) throws IOException {
        return Integer.parseInt(this.readString(len), 16);
    }

    public byte readByte(int len) throws IOException {
        return Byte.parseByte(this.readString(len));
    }

    public short readShort(int len) throws IOException {
        return Short.parseShort(this.readString(len));
    }

    public int readInt(int len) throws IOException {
        return Integer.parseInt(this.readString(len));
    }

    public long readLong(int len) throws IOException {
        return Long.parseLong(this.readString(len));
    }

    public float readFloat(int len, int decimalLen) throws IOException {
        return Float.valueOf(this.readString(len - decimalLen) + "." + this.readString(decimalLen)).floatValue();
    }

    public double readDouble(int len, int decimalLen) throws IOException {
        return Double.valueOf(this.readString(len - decimalLen) + "." + this.readString(decimalLen));
    }

    public DateTime readDate(String format) throws IOException {
        String date = this.readString(format.length());
        if (date == null || date.trim().equals("") || date.equals(new String("0000000000000000").substring(0, format.length()))) {
            return null;
        }
        return new DateTime(date, format);
    }

    public String readAll() throws IOException {
        int len;
        StringBuffer result = new StringBuffer();
        char[] buffer = new char[this.BUFFER_LEN];
        while ((len = this.read(buffer)) != -1) {
            result.append(new String(buffer, 0, len));
        }
        return result.toString();
    }
}

