/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.File;
import pt.opensoft.io.RegularExpressionFilenameFilter;
import pt.opensoft.text.Regex;
import pt.opensoft.util.StringUtil;

public class DosFilenameFilter
extends RegularExpressionFilenameFilter {
    protected String _originalExpression = null;

    public DosFilenameFilter(String regex) {
        this._originalExpression = regex;
        regex = StringUtil.replace(regex, ".", "\\.");
        regex = StringUtil.replace(regex, "*", ".*");
        regex = StringUtil.replace(regex, "?", ".?");
        this._regex = new Regex(regex, 1);
    }

    @Override
    public String toString() {
        return this._originalExpression;
    }

    public static void main(String[] args) {
        String dirname = args[0];
        String regex = args[1];
        File dir = new File(dirname);
        try {
            DosFilenameFilter filter = new DosFilenameFilter(regex);
            String[] filenames = dir.list(filter);
            System.out.println("PROCESSING DIR: " + dir);
            for (int i = 0; i < filenames.length; ++i) {
                String filename = filenames[i];
                System.out.println("FILE: " + filename);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

