/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.http;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.opensoft.http.HttpRequest;
import pt.opensoft.util.ListUtil;
import pt.opensoft.util.MapUtil;

public class MapHttpRequest
extends HttpRequest {
    private static final long serialVersionUID = 6525171158451461494L;
    private final Map<String, Object> objectMap;
    private final Map<String, String> headers;

    public MapHttpRequest(Map<String, Object> values) {
        super(null);
        this.objectMap = values;
        this.headers = new HashMap<String, String>();
    }

    public String getString(String key) {
        return (String)this.objectMap.get(key);
    }

    public Long getLong(String key) {
        return (Long)this.objectMap.get(key);
    }

    @Override
    public Object getValue(String key) {
        return this.objectMap.get(key);
    }

    @Override
    public List getNames() {
        return ListUtil.toList(this.objectMap.keySet());
    }

    @Override
    public String getQueryString() {
        return MapUtil.toString(this.objectMap, "&", "=");
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }
}

