/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.http;

import java.io.Serializable;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class HttpSessionsObserver
implements HttpSessionListener,
HttpSessionAttributeListener,
HttpSessionActivationListener,
Serializable {
    public static final String LOGGED_IN = "LOGGED_IN";
    public static final String SESSION_ACTIVATION_LISTENER = "sessionactivationlistener";
    protected static int loggedIn = 0;
    protected static int total = 0;

    public static synchronized int countLoggedIn() {
        return loggedIn;
    }

    public static synchronized int countTotal() {
        return total;
    }

    private boolean isLoggedIn(HttpSessionEvent event) {
        Object value = event.getSession().getAttribute(LOGGED_IN);
        if (value == null) {
            return false;
        }
        return value.toString().equalsIgnoreCase("true");
    }

    public synchronized void sessionCreated(HttpSessionEvent event) {
        event.getSession().setAttribute(SESSION_ACTIVATION_LISTENER, (Object)this);
        ++total;
    }

    public synchronized void sessionDestroyed(HttpSessionEvent event) {
        --total;
    }

    public synchronized void sessionDidActivate(HttpSessionEvent event) {
        ++total;
        if (this.isLoggedIn(event)) {
            ++loggedIn;
        }
    }

    public synchronized void sessionWillPassivate(HttpSessionEvent event) {
        --total;
        if (this.isLoggedIn(event)) {
            --loggedIn;
        }
    }

    public synchronized void attributeAdded(HttpSessionBindingEvent event) {
        Object value;
        if (LOGGED_IN.equals(event.getName()) && (value = event.getValue()) != null && value.toString().equalsIgnoreCase("true")) {
            ++loggedIn;
        }
    }

    public synchronized void attributeRemoved(HttpSessionBindingEvent event) {
        if (SESSION_ACTIVATION_LISTENER.equals(event.getName())) {
            --total;
        }
        if (LOGGED_IN.equals(event.getName())) {
            --loggedIn;
        }
    }

    public synchronized void attributeReplaced(HttpSessionBindingEvent event) {
        if (LOGGED_IN.equals(event.getName())) {
            Object value = event.getValue();
            loggedIn = value != null && value.toString().equalsIgnoreCase("true") ? ++loggedIn : --loggedIn;
        }
    }
}

