/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import pt.opensoft.io.FileUtil;
import pt.opensoft.io.ZipReader;
import pt.opensoft.logger.Logger;
import pt.opensoft.util.SystemParameters;

public class FileUpload {
    public static final int DEFAULT_MAX_UPLOAD_SIZE = 0xE600000;
    public static final int DEFAULT_MAX_MEMORY_SIZE = 10240;
    private static String DEFAULT_ENCODING = "ISO-8859-1";
    protected Logger logger;
    protected int maxUploadSize = 0xE600000;
    protected int maxMemorySize = 10240;
    protected File tempDir = new File(".");
    protected FileUploadBase upload;
    protected Map formList;
    protected List fileList;

    public static boolean isUploadRequest(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    public FileUpload() {
        this(Logger.getDefault());
    }

    public FileUpload(Logger logger) {
        this.logger = logger;
        this.formList = new HashMap();
        this.fileList = new ArrayList();
    }

    public FileUpload(String tempDir) {
        this(Logger.getDefault(), new File(tempDir));
    }

    public FileUpload(File tempDir) {
        this(Logger.getDefault(), tempDir);
    }

    public FileUpload(Logger logger, File tempDir) {
        this.logger = logger;
        this.tempDir = tempDir;
        this.formList = new HashMap();
        this.fileList = new ArrayList();
    }

    public FileUpload(int maxUploadSize, int maxMemorySize, File tempDir) {
        this(Logger.getDefault(), maxUploadSize, maxMemorySize, tempDir);
    }

    public FileUpload(Logger logger, int maxUploadSize, int maxMemorySize, File tempDir) {
        this.logger = logger;
        this.maxUploadSize = maxUploadSize;
        this.maxMemorySize = maxMemorySize;
        this.tempDir = tempDir;
        this.upload = this.getUpload();
        this.formList = new HashMap();
        this.fileList = new ArrayList();
    }

    public FileItem getParameter(String formName) {
        return (FileItem)this.formList.get(formName);
    }

    public Set getParameterNames() {
        return this.formList.keySet();
    }

    public List getFileList() {
        return this.fileList;
    }

    public FileItem getFileItem(int i) {
        return (FileItem)this.fileList.get(i);
    }

    public String getFileName(int i) {
        return FileUtil.getFilename(this.getFileItem(i).getName());
    }

    public InputStream getInputStream(int i) throws IOException {
        return this.getFileItem(i).getInputStream();
    }

    public Reader getReader(int i) throws IOException {
        return new InputStreamReader(this.getInputStream(i), SystemParameters.DEFAULT_ENCODING);
    }

    public ZipReader getZipReader(int i) throws IOException {
        return new ZipReader(this.getInputStream(i));
    }

    public void setMaxUploadSize(int maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean upload(HttpServletRequest request) {
        if (this.upload == null) {
            this.upload = this.getUpload();
        }
        if (!this.validateTempDir()) {
            this.logger.error((Object)("[FILE UPLOAD] directoria temporaria " + this.tempDir + " inexistente."));
            return false;
        }
        List items = null;
        try {
            items = this.upload.parseRequest(request);
        }
        catch (FileUploadException e) {
            this.logger.error((Object)("[FILE UPLOAD] " + e.getMessage()));
            return false;
        }
        for (FileItem item : items) {
            if (item.isFormField()) {
                this.processTextParameter(request, item);
                continue;
            }
            this.processFileParameter(request, item);
        }
        return true;
    }

    public void uploadWithException(HttpServletRequest request) throws FileUploadException {
        if (this.upload == null) {
            this.upload = this.getUpload();
        }
        this.validateTempDir();
        List items = null;
        items = this.upload.parseRequest(request);
        for (FileItem item : items) {
            if (item.isFormField()) {
                this.processTextParameter(request, item);
                continue;
            }
            this.processFileParameter(request, item);
        }
    }

    protected void processTextParameter(HttpServletRequest request, FileItem item) {
        if (this.formList == null) {
            this.formList = new HashMap();
        }
        this.formList.put(item.getFieldName(), item);
    }

    protected void processFileParameter(HttpServletRequest request, FileItem item) {
        if (this.fileList == null) {
            this.fileList = new ArrayList();
        }
        this.fileList.add(item);
    }

    private ServletFileUpload getUpload() {
        ServletFileUpload upload = new ServletFileUpload();
        DiskFileItemFactory factory = new DiskFileItemFactory(this.maxMemorySize, this.tempDir);
        upload.setFileItemFactory((FileItemFactory)factory);
        upload.setSizeMax((long)this.maxUploadSize);
        upload.setHeaderEncoding(DEFAULT_ENCODING);
        return upload;
    }

    private boolean validateTempDir() {
        if (!this.tempDir.exists() || !this.tempDir.isDirectory()) {
            return this.tempDir.mkdirs();
        }
        return true;
    }

    public void deleteFile(int i) {
        this.getFileItem(i).delete();
    }

    public void deleteFiles() {
        for (FileItem file : this.fileList) {
            file.delete();
        }
    }

    public int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public static void setHeaderEncoding(String encoding) {
        DEFAULT_ENCODING = encoding;
    }
}

