/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.http;

import javax.servlet.http.Cookie;
import pt.opensoft.http.HttpRequest;
import pt.opensoft.msg.Request;

public class CookieUtils {
    public static String getCookieValue(Request request, String cookieName) {
        HttpRequest httpRequest = (HttpRequest)request;
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            String name = cookies[i].getName();
            if (!name.equals(cookieName)) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    public static Cookie getCookie(String cookieName, String cookieValue) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setMaxAge(Integer.MAX_VALUE);
        cookie.setPath("/");
        return cookie;
    }

    public static Cookie getSecureCookie(String cookieName, String cookieValue) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setMaxAge(Integer.MAX_VALUE);
        cookie.setPath("/");
        cookie.setSecure(true);
        return cookie;
    }
}

