/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.field;

public class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = -268820800986627330L;
    public static final String DEFAULT_ERROR_ID = "X00";
    protected int line = -1;
    protected int column = -1;
    protected String errorId;

    public ValidationException(String message) {
        this(DEFAULT_ERROR_ID, message);
    }

    public ValidationException(String message, Throwable cause) {
        this(DEFAULT_ERROR_ID, message, cause);
    }

    public ValidationException(String errorId, String message) {
        super(message);
        this.errorId = errorId;
    }

    public ValidationException(String errorId, String message, Throwable cause) {
        super(message, cause);
        this.errorId = errorId;
    }

    public ValidationException(String errorId, String message, int line) {
        super(message);
        this.errorId = errorId;
        this.line = line;
    }

    public ValidationException(String errorId, String message, int line, Throwable cause) {
        super(message, cause);
        this.errorId = errorId;
        this.line = line;
    }

    public ValidationException(String errorId, String message, int line, int column) {
        super(message);
        this.errorId = errorId;
        this.line = line;
        this.column = column;
    }

    public ValidationException(String errorId, String message, int line, int column, Throwable cause) {
        super(message, cause);
        this.errorId = errorId;
        this.line = line;
        this.column = column;
    }

    public String getErrorId() {
        return this.errorId;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.errorId != null) {
            buffer.append(this.errorId).append("-");
        }
        buffer.append(super.getMessage());
        if (this.line != -1) {
            buffer.append(":").append(this.line);
        }
        if (this.column != -1 && this.line != -1) {
            buffer.append(",").append(this.column);
        }
        return buffer.toString();
    }
}

