/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.field;

import pt.opensoft.field.ExactNumericField;
import pt.opensoft.util.StringUtil;

public class PercentField
extends ExactNumericField {
    public static final int DEFAULT_PRECISION = 1;

    public PercentField(String name, String percent, int precision) {
        super(name, percent, precision);
    }

    public PercentField(String name, String percent) {
        this(name, percent, 1);
    }

    public PercentField(String name, long percent) {
        this(name, String.valueOf(percent), 1);
    }

    public PercentField(String name) {
        this(name, 0L);
    }

    public static boolean isValid(String percent, int precision) {
        if (percent == null || percent.trim().length() == 0) {
            return false;
        }
        if (percent.indexOf(46) != -1) {
            return false;
        }
        int pos = percent.indexOf(44);
        if (pos == -1 || pos > 3) {
            return false;
        }
        if (pos > percent.length() - precision - 1) {
            return false;
        }
        return StringUtil.isNumeric(StringUtil.remove(percent, String.valueOf(',')));
    }

    public String toHtml() {
        return this.toString() + "%";
    }

    @Override
    public String toString() {
        return this.format();
    }

    public static PercentField fromValidPercent(String name, String percent) {
        return new PercentField(name, StringUtil.remove(percent, String.valueOf(',')));
    }
}

