/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.field;

import java.math.BigInteger;
import pt.opensoft.field.CheckDigit;

public class CheckDigitMod8
extends CheckDigit {
    public CheckDigitMod8(int position) {
        super(1, position);
    }

    @Override
    public int calculate(String num) {
        return CheckDigitMod8.calculateControlDigitMod8(new BigInteger(num));
    }

    private static int calculateControlDigitMod8(BigInteger number) {
        BigInteger sum = CheckDigitMod8.calculateControlDigitSum(number);
        int rem = sum.remainder(BigInteger.valueOf(11L)).intValue();
        if (rem == 0 || rem == 1) {
            return 0;
        }
        return 11 - rem;
    }

    private static BigInteger calculateControlDigitSum(BigInteger number) {
        BigInteger sum = BigInteger.ZERO;
        String bigNumberAsString = number.toString();
        int length = bigNumberAsString.length();
        for (int i = length - 1; i >= 0; --i) {
            int di = Integer.parseInt(Character.toString(bigNumberAsString.charAt(i)));
            sum = sum.add(BigInteger.valueOf(di * ((length - i - 1) % 8 + 2)));
        }
        return sum;
    }
}

