/*
 * Decompiled with CFR 0.152.
 */
package pt.at.efapi.service;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jdom.Document;
import org.jdom.JDOMException;
import pt.at.efapi.enums.EfapiErrorEnum;
import pt.at.efapi.exception.ConfigFileException;
import pt.at.efapi.exception.RemoteServiceException;
import pt.at.efapi.service.ServiceConfiguration;
import pt.at.efapi.service.UserDTO;
import pt.at.efapi.util.EfapiLog;
import pt.at.efapi.util.EfapiVersion;
import pt.at.efapi.util.LogUtils;
import pt.opensoft.http.ConnectionTimeoutException;
import pt.opensoft.http.HttpResponse;
import pt.opensoft.http.JavaHttpConnection;
import pt.opensoft.text.Base64;
import pt.opensoft.util.ZipUtil;
import pt.opensoft.xml.XmlBuilder;

public abstract class RemoteService {
    protected static final String PARAMETER_ERROR = "error";
    protected static final String NO_ERROR_VALUE = "0";
    protected static final String PARAMETER_FILENAME = "filename";
    protected static final String PARAMETER_FILETYPE = "filetype";
    protected static final String PARAMETER_OPERATION = "operation";
    private static final String PARAMETER_NIF = "nif";
    private static final String PARAMETER_USER = "userId";
    private static final String PARAMETER_PASSWORD = "password";
    private static final String ENCODE = "UTF-8";
    private static final String USER_AGENT = "User-Agent";
    private static final String EFAPI_VERSION = "Efapi-Version";
    private static final String OPERATIVE_SYSTEM = "OS";
    private static final String JAVA = "java";
    private static final String USER_AGENT_VALUE = "EFAPICLI";
    private JavaHttpConnection httpConnection;

    protected RemoteService() {
    }

    protected void init(URL url) throws ConfigFileException {
        if (url == null) {
            LogUtils.put("serverUrl", "null");
            throw new IllegalArgumentException("RemoteService init illegal arguments");
        }
        LogUtils.put("serverUrl", url.toString());
        this.httpConnection = new JavaHttpConnection(url, 1);
        this.httpConnection.setTimeout((int)ServiceConfiguration.getTimeout());
        if (ServiceConfiguration.usingProxy()) {
            this.httpConnection.setProxy(ServiceConfiguration.getProxyHost(), ServiceConfiguration.getProxyPort(), ServiceConfiguration.getProxyUser(), ServiceConfiguration.getProxyPass());
        }
    }

    protected Document send() throws RemoteServiceException {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            String osName = System.getProperty("os.name");
            if (!StringUtils.isEmpty(osName)) {
                headers.put(OPERATIVE_SYSTEM, osName);
            }
            headers.put(USER_AGENT, USER_AGENT_VALUE);
            headers.put(JAVA, "jdk" + System.getProperty("java.version"));
            headers.put(EFAPI_VERSION, EfapiVersion.APP_VERSION);
            this.httpConnection.addRequestHeaders(headers);
            HttpResponse response = this.httpConnection.send();
            if (response == null) {
                throw new IOException("Response is null!");
            }
            XmlBuilder xmlBuilder = new XmlBuilder(false);
            List saxParseExceptions = xmlBuilder.parse(new StringReader(response.getBody()));
            if (saxParseExceptions.isEmpty()) {
                return xmlBuilder.getDocument();
            }
            return null;
        }
        catch (ConnectionTimeoutException e) {
            EfapiLog.writeLog("Error sending request: Timeout");
            throw new RemoteServiceException(EfapiErrorEnum.COMMUNICATION_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            EfapiLog.writeLog("Error sending request: IOException, message = " + e.getMessage());
            throw new RemoteServiceException(EfapiErrorEnum.COMMUNICATION_ERROR, (Throwable)e);
        }
        catch (JDOMException e) {
            EfapiLog.writeLog("Error sending request: JDOMException, message = " + e.getMessage());
            throw new RemoteServiceException(EfapiErrorEnum.COMMUNICATION_ERROR, (Throwable)e);
        }
    }

    protected void addUserParameters(UserDTO userDTO) {
        String nif = userDTO.getNif();
        String userId = userDTO.getUserid();
        this.addParameter(PARAMETER_NIF, nif);
        this.addParameter(PARAMETER_USER, userId);
        this.addParameter(PARAMETER_PASSWORD, userDTO.getPassword());
        LogUtils.put(PARAMETER_NIF, nif);
        LogUtils.put(PARAMETER_USER, userId);
    }

    protected void addOperationParameters(String operation) {
        this.addParameter(PARAMETER_OPERATION, operation);
        LogUtils.put(PARAMETER_OPERATION, operation);
    }

    protected void addFiletypeParameter(String filetype) {
        this.addParameter(PARAMETER_FILETYPE, filetype);
        LogUtils.put(PARAMETER_FILETYPE, filetype);
    }

    protected void addParameter(String name, String value) {
        this.httpConnection.addParameter(name, RemoteService.encode(value));
    }

    protected static String zip(String string) throws IOException {
        return ZipUtil.deflate(string);
    }

    protected static String unzip(String zippedString) throws IOException {
        return ZipUtil.inflate(zippedString);
    }

    protected static String encode(String message) {
        try {
            return URLEncoder.encode(Base64.encode(message), ENCODE);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    protected static String decode(String message) {
        return Base64.decode(message, false);
    }
}

