/*
 * Decompiled with CFR 0.152.
 */
package pt.at.efapi.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import pt.at.efapi.enums.EfapiErrorEnum;
import pt.at.efapi.exception.ConfigFileException;
import pt.at.efapi.exception.RemoteServiceException;
import pt.at.efapi.service.RemoteService;
import pt.at.efapi.service.ServiceConfiguration;
import pt.at.efapi.service.UserDTO;
import pt.at.efapi.util.EfapiLog;
import pt.at.efapi.util.LogUtils;
import pt.opensoft.util.ListUtil;

public class DeleteFilesService
extends RemoteService {
    private static final String OPERATION_DELETE = "efapiDeleteFiles";
    private static final String PARAMETER_NUMBER_OF_FILES = "numberOfFiles";
    private static final String DELETE_ENDPOINT = "/apagarFicheiros";

    public void run(UserDTO userDTO, List<String> files, String filetype) throws RemoteServiceException, ConfigFileException {
        if (userDTO == null || filetype == null || files == null || files.isEmpty()) {
            throw new IllegalArgumentException("Delete Service Illegal Arguments");
        }
        long startTime = System.currentTimeMillis();
        try {
            this.init(new URL(ServiceConfiguration.getServerUrl() + DELETE_ENDPOINT));
            this.addUserParameters(userDTO);
            this.addOperationParameters(OPERATION_DELETE);
            this.addParameterFileDeletion(files);
            this.addFiletypeParameter(filetype);
            if (files != null && !files.isEmpty()) {
                EfapiLog.infoWriteLog("Requesting server deletion of received files: [ " + ListUtil.toString(files, ", ") + " ].");
            }
        }
        catch (MalformedURLException e) {
            EfapiLog.writeLog("DeleteRemoteFiles: Error setting the URL");
            throw new RemoteServiceException(EfapiErrorEnum.COMMUNICATION_ERROR, (Throwable)e);
        }
        Document remoteDeleteResult = this.send();
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        LogUtils.put("filesToDelete", Integer.toString(files.size()));
        this.processRemoteDeletionResponse(remoteDeleteResult);
        LogUtils.getErrorCodeAndResult(Integer.parseInt("0"), "OK");
        String logToPrint = LogUtils.prepareLogStructure();
        EfapiLog.logToConsole(logToPrint, elapsedTime);
        EfapiLog.infoWriteLog(logToPrint, elapsedTime);
        EfapiLog.infoWriteLog("Server files deletion successful.");
    }

    private void processRemoteDeletionResponse(Document remoteDeleteResult) throws RemoteServiceException {
        if (remoteDeleteResult == null || !remoteDeleteResult.hasRootElement()) {
            EfapiLog.writeLog("DeleteRemoteFiles(processResponse): Answer was empty");
            throw new RemoteServiceException(EfapiErrorEnum.DELETE_REMOTE_FAILED);
        }
        Element element = remoteDeleteResult.getRootElement();
        if (!element.getAttributeValue("error").equals("0")) {
            Integer codeError = Integer.valueOf(element.getAttributeValue("error"));
            EfapiLog.writeLog("DeleteRemoteFiles(processResponse): Error code has value " + codeError);
            throw new RemoteServiceException(EfapiErrorEnum.getError(codeError));
        }
        if (element.getAttribute("operation") == null || !element.getAttributeValue("operation").equals(OPERATION_DELETE) || element.getChildren().isEmpty()) {
            EfapiLog.writeLog("DeleteRemoteFiles(processResponse): Answer was invalid");
            throw new RemoteServiceException(EfapiErrorEnum.DELETE_REMOTE_FAILED);
        }
        List<String> result = this.getNotDeletedFilesInResponseContent(element);
        LogUtils.put("filesDeleted", Integer.toString(element.getChildren().size() - result.size()));
        if (!result.isEmpty()) {
            EfapiLog.writeLog("DeleteRemoteFiles(processResponse): Some files were not correctly erased in the server.");
            String filesNotDeletedString = result != null ? ListUtil.toString(result, ", ") : "";
            LogUtils.put("filesNotDeleted", filesNotDeletedString);
            throw new RemoteServiceException(EfapiErrorEnum.DELETE_REMOTE_FAILED);
        }
    }

    private List<String> getNotDeletedFilesInResponseContent(Element element) {
        ArrayList<String> result = new ArrayList<String>();
        List children = element.getChildren();
        for (Element elem : children) {
            if (elem.getAttributeValue("error") == null) continue;
            result.add(DeleteFilesService.decode(elem.getAttributeValue("filename")));
        }
        return result;
    }

    private void addParameterFileDeletion(List<String> filesSaved) {
        int numberOfFilesToDelete = filesSaved.size();
        for (int iter = 0; iter < numberOfFilesToDelete; ++iter) {
            String filename = filesSaved.get(iter);
            String command = "filename" + (iter + 1);
            this.addParameter(command, filename);
        }
        this.addParameter(PARAMETER_NUMBER_OF_FILES, Integer.toString(numberOfFilesToDelete));
    }
}

